<?php
include_once dirname(__FILE__).'/class.Pagination.php';
class Dbfunctions extends Pagination
{
public function getFieldList($con,$tblName, $fldName, $aSeparator = ",", $defaultVal = "", $encloseChar="", $optCondition = "")
	{
		if(trim($optCondition) != "")
		{
			$condition = " WHERE " . $optCondition;
		}
		else
		{
			$condition = "";
		}
		
		$fieldList = "";
	
		$tmpSql = "SELECT " . $fldName . " FROM " . $tblName . " " . $condition;
		//echo("<br>SQL=>".$tmpSql."<br>");
		$rs = mysqli_query($tmpSql,$con);
		if( (!($rs)) || (!($rec=mysqli_fetch_array($rs))) )
		{
			//not found, do nothing
		}
		else
		{
			do 
			{
				if($fieldList != "")
				{
					$fieldList = $fieldList . $aSeparator;
				}
				$fieldList = $fieldList . $encloseChar . $rec[$fldName] . $encloseChar;
			} while(($rec=mysqli_fetch_array($rs)));
		}
		
		if($fieldList == "")
		{
			$fieldList = $defaultVal;
		}

		return $fieldList;
	}
// ************************END************************************************************	


public function fetchsort($con,$tblName,$optCondition="",$optorder="",$optlimit="",$optorderType="ASC") 
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
		$condition = "";
	}
	
	if(trim($optlimit) != "")
	{
	$limit = " ".$optlimit;
	}
	else
	{
		$limit = "";
	}
	if(trim($optorder) != "")
	{
 		//$sql="SELECT * FROM " . $tblName . $condition ." ORDER BY ". $optorder." ".$optorderType. $limit;
 		$sql="SELECT * FROM " . $tblName . $condition ." ORDER BY ". $optorder." ". $limit;
	}
	else
	{
		$sql="SELECT * FROM " . $tblName . $condition. $limit;
	}
	//echo $sql; 
 $result = mysqli_query($con,$sql);
 if(!$result){
  trigger_error("Problem selecting data");
 }
 while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
  $result_array[] = $row;
 }
if(count($result_array)>0)
{
 return $result_array;	
 }
 else
 {
 $default_val=array();
 return $default_val;
 }
}
	
	
	
	
	/*Returns data value if data exists in a table (suitable for integer or string data) *************************/
	public function getDataFromTable($con,$tblName, $fldName,  $optCondition)
	{
	$defaultVal="";
	
		if(trim($optCondition) != "")
		{
			$condition = $optCondition ;
		}
		else
		{
			$condition = "";
		}
	//echo ("select " . $fldName . " from " . $tblName . " where " . $condition);

		$rs = mysqli_query($con,"select " . $fldName . " from " . $tblName . " where " . $condition);
	
		if( (!($rs)) || (!($rec=mysqli_fetch_array($rs))) )
		{
			//not found
			return $defaultVal;
		}
		else if(is_null($rec[0]))
		{
			//found
			return $defaultVal;
		}
		else
		{
			//found
			return $rec[0];
		}
	}

// ********************************************END**********************************************************************	
	
	//FETCH ALL ROWS FROM A TABLE

	
	/*Returns only 1 data *************************/
	public function getFirstData($con,$tblName, $fldName,  $optCondition)
	{
	$defaultVal="";
	
		if(trim($optCondition) != "")
		{
			$condition = " WHERE " . $optCondition;
		}
		else
		{
			$condition = "";
		}
		//echo ("select " . $fldName . " from " . $tblName . $condition);

		$rs = mysqli_query($con,"select " . $fldName . " from " . $tblName . $condition. " LIMIT 0,1");
		
		if( (!($rs)) || (!($rec=mysqli_fetch_array($rs))) )
		{
			//not found
			return $defaultVal;
		}
		else if(is_null($rec[0]))
		{
			//found
			return $defaultVal;
		}
		else
		{
			//found
			return $rec[0];
		}
	}

// ********************************************END**********************************************************************	
	
	
	
	//CHECKING EXISTANCE  IN A TABLE
	public function existsInTable($con,$tblName, $condition)
	{
	
	if(trim($condition) != "")
		{
			$condition = " WHERE " . $condition;
		}
		else
		{
			$condition = "";
		}
		//echo ("select * from " . $tblName . " where " . $condition)."<br>";
		
		$rs = mysqli_query($con,"select * from " . $tblName . $condition);
		if( (!($rs)) || (!($rec=mysqli_fetch_array($rs))) )
		{
			//not found
			return 0;
		}
		else
		{
			//found
			return 1;
		}
	}
// ********************************END****************************************************************************************	
	




//INSERT DATA INTO TABLE AND GET THE INSERTED ID******************************************************************************	
public function insertToTable($con,$tblName, $string)
{
$rs= mysqli_query($con,"INSERT INTO " . $tblName . " VALUES(". $string.")");
if($rs)
{
$lastId=mysqli_insert_id($con);
return $lastId;
}
else
{
return 0;
}
}
// ********************************END****************************************************************************************	


//INSERT TO TABLE USING SET METHOD************************************************************************************************
public function insertSet($con,$tblName,$string)
{
	$condition = " WHERE " . $condition;
	//echo "INSERT INTO  " . $tblName . " SET " .  $string;exit;
	$rs= mysqli_query($con,"INSERT INTO  " . $tblName . " SET " .  $string);
	if($rs)
	{
		$lastId=mysqli_insert_id($con);
		return $lastId;
	}
	else
	{
		return 0;
	}
}
// ********************************END****************************************************************************************	



//DELETE DATA FROM TABLE
public function deleteFromTable($con,$tblName, $condition)
{

if(trim($condition) != "")
	{
	$condition = " WHERE " . $condition;
	}
else
	{
	$condition = "";
	}
$rs= mysqli_query($con, "DELETE FROM " . $tblName . $condition);
}
// ********************************END****************************************************************************************	


//FETCH  ROWS FROM A TABLE USING DISTINCT
function fetchDistinct($con,$tblName,$distinctname,$optCondition="",$optorder="",$optlimit="",$optorderType="ASC") 
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
	$condition = "";
	}
	
	if(trim($optlimit) != "")
	{
	$limit = " ".$optlimit;
	}
	else
	{
		$limit = "";
	}
	
if(trim($optorder) != "")	
{
 $sql="SELECT distinct(".$distinctname.") FROM " . $tblName . $condition ." ORDER BY ". $optorder." ".$optorderType. $limit;
 }
 else
 {
 $sql="SELECT distinct(".$distinctname.") FROM " . $tblName . $condition. $limit;
 }
 //echo $sql;
 $result = mysqli_query($con, $sql);
 if(!$result){
  trigger_error("Problem selecting data");
 }
 while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
  $result_array[] = $row;
 }
if(count($result_array)>0)
{
 return $result_array;	
 }
 else
 {
 $default_val=array();
 return $default_val;
 }
}


//UPDATE  TABLE
public function updateTable($con,$tblName,$string, $condition)
{
$condition = " WHERE " . $condition;
 $rs= mysqli_query($con, "UPDATE " . $tblName . " SET " .  $string . $condition) or die("UPDATE " . $tblName . " SET " .  $string . $condition."<br/>".mysql_error());
// echo "UPDATE " . $tblName . " SET " .  $string . $condition;exit;
}
// ********************************END****************************************************************************************	


//Next Auto increment value of a table.
public function autoIncrement($con,$tblName,$string, $condition)
{
$query_next = mysqli_query($con,"SHOW TABLE STATUS LIKE '". $tblName."'");
$row_next = mysqli_fetch_array($query_next);
 $next_id = $row_next[Auto_increment] ;//exit;
 return $next_id;
}
// ********************************END****************************************************************************************	



//FETCH ALL ROWS FROM A TABLE
public function fetch($con,$tblName,$optCondition="",$optorder="",$optlimit="",$optorderType="ASC") 
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
		$condition = "";
	}
	
	if(trim($optlimit) != "")
	{
	$limit = " ".$optlimit;
	}
	else
	{
		$limit = "";
	}
	if(trim($optorder) != "")
	{
 		$sql="SELECT * FROM " . $tblName . $condition ." ORDER BY ". $optorder." ".$optorderType. $limit;
	}
	else
	{
		$sql="SELECT * FROM " . $tblName . $condition. $limit;
	}
	//echo $sql;
 $result = mysqli_query($con, $sql);
// echo $result;
 if(!$result){
  trigger_error("Problem selecting data");
 }
 while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
   $result_array[] = $row;
  
 }
if(count($result_array)>0)
{
 return $result_array;	
 }
 else
 {
 $default_val=array();
 return $default_val;
 }
}

//fetch distinct value from a single column of a table
public function fetchSingleColumn($con,$tblName,$column_name='id',$optCondition="",$optorder="",$optlimit="",$optorderType="ASC"){
	$result_array=array();
	if(trim($optCondition) != ""){
		$condition = " WHERE " . $optCondition;
	}else{
		$condition = "";
	}
	
	if(trim($optlimit) != ""){
		$limit = " ".$optlimit;
	}else{
		$limit = "";
	}
	if(trim($optorder) != ""){
 		$sql="SELECT distinct(".$column_name.") FROM " . $tblName . $condition ." ORDER BY ". $optorder." ".$optorderType. $limit;
	}else{
		$sql="SELECT distinct(".$column_name.") FROM " . $tblName . $condition. $limit;
	}	
	$result = mysqli_query($con, $sql);
	if(!$result){
		trigger_error("Problem selecting data");
	}
	while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
		$result_array[] = $row[$column_name];
	}		
	return $result_array;		
}
//fetch distinct value from a single column of a table with join
public function fetchSingleColumnAlias($con,$tblName,$column_name='id',$alias_name='id',$optCondition="",$optorder="",$optlimit="",$optorderType="ASC"){
	$result_array=array();
	if(trim($optCondition) != ""){
		$condition = " WHERE " . $optCondition;
	}else{
		$condition = "";
	}
	
	if(trim($optlimit) != ""){
		$limit = " ".$optlimit;
	}else{
		$limit = "";
	}
	if(trim($optorder) != ""){
 		$sql="SELECT distinct(".$column_name.") FROM " . $tblName . $condition ." ORDER BY ". $optorder." ".$optorderType. $limit;
	}else{
		$sql="SELECT distinct(".$column_name.") FROM " . $tblName . $condition. $limit;
	}		
	$result = mysqli_query($con, $sql);
	if(!$result){
		trigger_error("Problem selecting data");
	}
	while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
		$result_array[] = $row[$alias_name];
	}		
	return $result_array;		
}
// ********************************END****************************************************************************************	



//FETCH ALL ROWS FROM A TABLE USING LEFT JOIN
function leftJoin($con,$tblName1,$tblName2,$tbl1Param,$tbl2Param,$optCondition="",$optDistinct="id") 
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
	$condition = "";
	}
	
	
   $sql="SELECT DISTINCT ". $tblName1.".".$optDistinct." FROM " . $tblName1 . " LEFT JOIN ". $tblName2 ." ON ".$tblName1.".".$tbl1Param."=".$tblName2.".".$tbl2Param. $condition;
 $result = mysqli_query($con, $sql);
 
 if(!$result){
  trigger_error("Problem selecting data");
 }
 while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
  $result_array[] = $row;
 }
if(count($result_array)>0)
{
 return $result_array;	
 }
 else
 {
 $default_val=array();
 return $default_val;
 }
}

// ********************************END****************************************************************************************	


//FETCH ALL ROWS FROM A TABLE USING LEFT JOIN
function leftJoinCount($con,$tblName1,$tblName2,$tbl1Param,$tbl2Param,$optCondition="") 
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
	$condition = "";
	}
	
  $sql="SELECT DISTINCT ". $tblName1.".id FROM " . $tblName1 . " LEFT JOIN ". $tblName2 ." ON ".$tblName1.".".$tbl1Param."=".$tblName2.".".$tbl2Param. $condition;
 $result = mysqli_query($con, $sql);
 return mysqli_num_rows($result);

}

// ********************************END****************************************************************************************	

//FETCH SINGLE ROW or specific Column FROM A TABLE (Kishor - 17-09-2011)
function fetchColumns($con,$tblName,$field,$optCondition="") 
{
	if(trim($optCondition) != "")
	{
		$sql = "SELECT ".$field." from ".$tblName." WHERE " . $optCondition;
	}
	else
	{
		$sql = "SELECT ".$field." from ".$tblName;
	}
	//echo $sql;

 $result = mysqli_query($con, $sql);
return mysqli_fetch_array($result);
}
// ********************************END****************************************************************************************	



//FETCH SINGLE ROW or specific Column FROM A TABLE (Sakti - 16-12-2011)
function fetchmultiColumns($con,$tblName,$field,$optCondition="") 
{
	if(trim($optCondition) != "")
	{
		$sql = "SELECT ".$field." from ".$tblName." WHERE " . $optCondition;
	}
	else
	{
		$sql = "SELECT ".$field." from ".$tblName;
	}
	//echo $sql;
$result = mysqli_query($con, $sql);
 if(!$result){
  trigger_error("Problem selecting data");
 }
 while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
  $result_array[] = $row;
 }
if(count($result_array)>0)
{
 return $result_array;	
 }
 else
 {
 $default_val=array();
 return $default_val;
 }
}
// ********************************END****************************************************************************************	

//FETCH SINGLE ROW FROM A TABLE
function fetchSingle($con,$tblName,$optCondition="")
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
	$condition = "";
	}
	
 $sql="SELECT * FROM " . $tblName . $condition;
//echo $sql;
 $result = mysqli_query($con, $sql);
return mysqli_fetch_array($result);
}

// ********************************END****************************************************************************************	
##############################################################
################ Fetch keyValue pair##########################
##############################################################
public function fetch_Key_value($con,$tblName,$keycol='id',$valuecol='id',$cond='') 
{	$result_array=array();
	if(trim($cond) != ""){
		$condition = " WHERE ".$cond;
	}else{
		$condition='';	
	}
	$sql="SELECT * FROM " . $tblName . $condition;				
	$result = mysqli_query($con, $sql);	
	if(!$result){
		trigger_error("Problem selecting data");
	}
	while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){		
		$key=$row[$keycol];	
		$result_array[$key] = $row[$valuecol];
	}			
	return $result_array;	
}

//TOTAL ROWS
function countRows($con,$tblName,$optCondition="") 
{
	if(trim($optCondition) != "")
	{
	$condition = " WHERE " . $optCondition;
	}
	else
	{
	$condition = "";
	}
	
$sql="SELECT * FROM " . $tblName . $condition;
 // print $sql;
 $result = mysqli_query($con, $sql);
 if(!$result){
  trigger_error("Problem selecting data");
 }
$num=mysqli_num_rows($result);
return $num;
}

// ********************************END****************************************************************************************	


/*Format Date Time to d-M-Y or any other...*/
	public function formatMyDateTime($a_date, $a_format, $is_time_stamp = 0, $a_default_value = "")
	{
		if(is_null($a_date))
		{
			return($a_default_value);
		}
		else
		{
			if($is_time_stamp == 1)
			{
				//--- supplied date time is a TimeStamp, so no conversion required
				$tmpdt_stamp = $a_date;
			}
			else
			{
				//--- supplied date time is not a TimeStamp, but a string
				$tmpdt_stamp = strtotime($a_date);
			}
			return(date($a_format, $tmpdt_stamp));
		}
	}
	
	
	
//String cut to a limited words************************************************	
public function cut($string, $max_length){
	if (strlen($string) > $max_length){
		$string = substr($string, 0, $max_length);
		$pos = strrpos($string, " ");
		if($pos === false) {
				return substr($string, 0, $max_length)."...";
		}
			return substr($string, 0, $pos)."...";
	}else{
		return $string;
	}
}	
//***********************************************	


 //calculate years of age (input string: YYYY-MM-DD)
  public function age($birthday){
    list($year,$month,$day) = explode("-",$birthday);
    $year_diff  = date("Y") - $year;
    $month_diff = date("m") - $month;
    $day_diff   = date("d") - $day;
    if ($day_diff < 0 || $month_diff < 0)
      $year_diff--;
    return $year_diff;
  }
  
  
//Text Area formatting************************************************	
public function textArea($string){
	$str = str_replace("\r",'<br>',$string); 
 $str=stripslashes($str);	//exit;
$str=mysqli_real_escape_string($str);
return $str;
}	
//***********************************************	  


//Create Random number************************************************	
public function createRandomPassword()
{
    $chars = "abcdefghijkmnopqrstuvwxyz023456789ABCDEWFGHJKLMNOPQRSTUVWXYZ";
    srand((double)microtime()*1000000);
    $i = 0;
    $pass = '' ;
    while ($i <= 6)
	 {
		$num = rand() % 70;
		$tmp = substr($chars, $num, 1);
		$pass = $pass . $tmp;
        $i++;
     }
    return $pass;
}
//***********************************************	  




//FIND URL OF THE SITE *******************************************************

public function get_server() {
	$protocol = 'http';
	if (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443') {
		$protocol = 'https';
	}
	$host = $_SERVER['HTTP_HOST'];
	$baseUrl = $protocol . '://' . $host;
	if (substr($baseUrl, -1)=='/') {
		$baseUrl = substr($baseUrl, 0, strlen($baseUrl)-1);
	}
	return $baseUrl;

}

//********************************************************************************



//FIND URL OF THE SITE *******************************************************

public function createStars($green) {
	$white=5-$green;
	$cs = new Dbfunctions();
	$mainUrl=$cs->get_server();	
	//for local
	$gimg=$mainUrl."/trip_megamart/trip123@/images/green_star.gif";
	$wimg=$mainUrl."/trip_megamart/trip123@/images/white_star.gif";
	//for server
	//$gimg=$mainUrl."/trip123@/images/green_star.gif";
	//$wimg=$mainUrl."/trip123@/images/white_star.gif";
for($i=1;$i<=$green;$i++)
	{
	echo "<img src=$gimg width='16' height='16' align='top'>";
	}
for($i=1;$i<=$white;$i++)
	{
	echo "<img src=$wimg width='16' height='16' align='top'>";
	}

}





//FIND CAD PRICE FROM USD*******************************************************

public function toCAD($usd,$factor) {
	return $usd*$factor;

}
  
  
  
  public function dateTimeDiff($data_ref)
  {
		   $time =  strtotime($data_ref)-time(); // to get the time since that moment
		
	if($time<0)
	{
	echo "CLOSED";
	}
else 
{
$tokens = array (
		31536000 => 'year',
		2592000 => 'month',
		/*604800 => 'week',*/
		86400 => 'day',
		3600 => 'hour',
		60 => 'minute',
		1 => 'second'
		);
	foreach ($tokens as $unit => $text) {
if ($time < $unit) continue;
$numberOfUnits = floor($time / $unit);


return "Closing in ".$numberOfUnits.' '.$text.(($numberOfUnits>1)?'s':'');

}
	 	
}
}
  
}



//********************************************************************************
?>