<?php
require 'src/Mandrill/Messages.php';
require 'src/Mandrill.php';
try {
    $mandrill = new Mandrill_Messages(new Mandrill("hA4TAeDilFCIp0h6fV9jTQ"));
    $message = array(
        'html' => '<p>Example HTML content</p>',
        'text' => 'Example text content',
        'subject' => 'example subject',
        'from_email' => 'ravipandey@tripmegamart.com',
        'from_name' => 'Example Name',
        'to' => array(
            array(
                'email' => 'ravikantvicky@gmail.com',
                'name' => 'Recipient Name',
                'type' => 'to'
            )
        ),
        'headers' => array('Reply-To' => 'ravipandey@tripmegamart.com'),
        'important' => true,
        'attachments' => array(
            array(
                'type' => 'text/pdf',
                'name' => 'FLIGHT.pdf',
                'content' => base64_encode(file_get_contents('/home/vickytri/public_html/tripmegamart.org/flight/pdftickets/FLIGHT.pdf'))
            )
        ),
    );
    $async = "";
    $ip_pool = 'Main Pool';
    $result = $mandrill->send($message);
    //$result = $mandrill->search();
    echo "<pre>";
    print nl2br(print_r($result,true));
    echo "</pre>";
    /*
    Array
    (
        [0] => Array
            (
                [email] => recipient.email@example.com
                [status] => sent
                [reject_reason] => hard-bounce
                [_id] => abc123abc123abc123abc123abc123
            )
    
    )
    */
} catch(Mandrill_Error $e) {
    // Mandrill errors are thrown as exceptions
    echo 'A mandrill error occurred: ' . get_class($e) . ' - ' . $e->getMessage();
    // A mandrill error occurred: Mandrill_Unknown_Subaccount - No subaccount exists with the id 'customer-123'
    throw $e;
}
?>