<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Escalation extends CI_Controller 
{

	public function __construct() 
	{
		parent::__construct();
		$this->load->model("user_model");
		$this->load->model("tickets_model");
		$this->load->model("home_model");
		if(!$this->user->loggedin) {
			redirect(site_url("login"));
		}
	}

	public function index($catid=0) 
	{
		$catid = intval($catid);
		if(!$this->common->has_permissions(array(
			"admin", "ticket_manager"), $this->user)) {
			$this->template->error(lang("error_85"));
		}
		$this->template->loadData("activeLink", 
			array("escalation" => array("general" => 1)));

		$this->template->loadContent("escalation/index.php", array(
			"page" => "index",
			"catid" => $catid
			)
		);
	}
	
		public function ticket_page($page, $catid=0) 
	{

		// get custom view
		$custom_view = $this->tickets_model
			->get_custom_view($this->user->info->custom_view, 
				$this->user->info->ID);

		$catid = intval($catid);
		$this->load->library("datatables");

		$this->datatables->set_default_order("tickets.last_reply_timestamp", "desc");

		// Set page ordering options that can be used
		$this->datatables->ordering(
			array(
				 0 => array(
				 	"tickets.ID" => 0
				 ),
				 1 => array(
				 	"tickets.title" => 0
				 ),
				 /*2 => array(
				 	"tickets.priority" => 0
				 ),*/
				 3 => array(
				 	"tickets.status" => 0
				 ),
				 4 => array(
				 	"tickets.categoryid" => 0
				 ),
				 7 => array(
				 	"tickets.last_reply_timestamp" => 0
				 ),
			)
		);

		if($page == "index") {
			$this->datatables->set_total_rows(
				$this->tickets_model
					->get_tickets_total_escalated($catid, $custom_view, $this->datatables)
			);
			$tickets = $this->tickets_model->get_tickets_escalated($catid, $this->datatables, $custom_view);
		}
		
	/*	$prioritys = array(0 => "<span class='label label-info'>".lang("ctn_429")."</span>", 1 => "<span class='label label-primary'>".lang("ctn_430")."</span>", 2=> "<span class='label label-warning'>".lang("ctn_431")."</span>", 3 => "<span class='label label-danger'>".lang("ctn_432")."</span>");*/

		foreach($tickets->result() as $r) {
			

			if($r->status == 0) {
				$status = lang("ctn_465");
			} elseif($r->status == 1) {
				$status = lang("ctn_466");
			} elseif($r->status == 2) {
				$status = lang("ctn_467");
			}
            
            $tickets_assign=$this->tickets_model->get_last_assign($r->ID);
            foreach($tickets_assign->result() as $la) {
                $last_assigned_timestamp=$la->timestamp;
            }
			if(isset($r->client_username)) {
		        $user = $this->common->get_user_display(array("username" => $r->client_username, "avatar" => $r->client_avatar, "online_timestamp" => $r->client_online_timestamp));
		    } else {
		        $user = '<div class="user-box-avatar"><img src="'.base_url().$this->settings->info->upload_path_relative.'/guest.png'.'" data-toggle="tooltip" data-placement="bottom" title="'.$r->guest_email.'"></div>';
		    }

		    if($r->last_reply_userid ==0) {
		    	$last_reply = $user . date($this->settings->info->date_format,$last_assigned_timestamp);
		    } else {
		    	$last_reply =  $this->common->get_user_display(array("username" => $r->lr_username, "avatar" => $r->lr_avatar, "online_timestamp" => $r->lr_online_timestamp)) . date($this->settings->info->date_format,$last_assigned_timestamp);
		    }

			
			$this->datatables->data[] = array(
				$r->ID,
				$r->title,
				/*$prioritys[$r->priority],*/
				$status,
				$r->cat_name,
				$user,
				$this->common->get_user_display(array("username" => $r->username, "avatar" => $r->avatar, "online_timestamp" => $r->online_timestamp)),
				$last_reply
			);
		}

		echo json_encode($this->datatables->process());
	}
	
}

?>